using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace DataRowState
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
    public class Form1 : System.Windows.Forms.Form
    {
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if (components != null) 
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

		#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(292, 273);
            this.Name = "Form1";
            this.Text = "Form1";
            this.Load += new System.EventHandler(this.Form1_Load);

        }
		#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() 
        {
            Application.Run(new Form1());
        }

        private void Form1_Load(object sender, System.EventArgs e)
        {
            DemonstrateRowState();
        }

        private void DemonstrateRowState()
        {
        // Run a function to create a DataTable with one column.
        DataTable myTable = MakeTable();
        DataRow myRow;

        // Create a new DataRow.
        myRow = myTable.NewRow();
        // Detached row.
            if (myRow.RowState == System.Data.DataRowState.Detached)
            {
                Console.WriteLine("New detached row: " + myRow.RowState.ToString());
            }
            Console.WriteLine("Post new row: " + myRow.RowState.ToString());

        myTable.Rows.Add(myRow);
        // New row.
            if (myRow.RowState == System.Data.DataRowState.Added)
            {
                Console.WriteLine("Newly added row: " + myRow.RowState.ToString());
            }
        
            Console.WriteLine("Post Add, pre-change " + myRow.RowState.ToString());

        myRow["FirstName"] = "Fred";
        Console.WriteLine("Post Add, post-change " + myRow.RowState.ToString());
        // Row is now modified but state still shows "added".
            if (myRow.RowState == System.Data.DataRowState.Modified)
            {
                Console.WriteLine("Modified row: " + myRow.RowState.ToString());
            }

            myTable.AcceptChanges();
        // Changes accepted. Rowstate now shows "unchanged".
            if (myRow.RowState == System.Data.DataRowState.Unchanged)
            {
                Console.WriteLine("Modified row post accept changes: " + myRow.RowState.ToString());
            }
        
            Console.WriteLine("AcceptChanges " + myRow.RowState.ToString());

        myRow["FirstName"] = "Scott";
        //Re-Modified row.
            if (myRow.RowState == System.Data.DataRowState.Modified)
            {
                Console.WriteLine("Modified row: " + myRow.RowState.ToString());
            }
        
            Console.WriteLine("Modified " + myRow.RowState.ToString());

        myRow.Delete();
        // Deleted row.
            if (myRow.RowState == System.Data.DataRowState.Deleted) 
            {
                Console.WriteLine("Deleted row: " + myRow.RowState.ToString());
            }
        
            Console.WriteLine("Deleted:" + myRow.RowState.ToString());

        myRow.RejectChanges();
        Console.WriteLine("Undeleted: " + myRow.RowState.ToString());

    }


  private DataTable MakeTable()
  {
        // Make a simple table with one column.
        DataTable myTable = new DataTable("myTable");
        DataColumn dcFirstName =new DataColumn("FirstName", Type.GetType("System.String"));
        myTable.Columns.Add(dcFirstName);
        return myTable;
  }

	}
}
